(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     30432,        870]*)
(*NotebookOutlinePosition[     31995,        915]*)
(*  CellTagsIndexPosition[     31951,        911]*)
(*WindowFrame->Normal*)



Notebook[{
Cell["N\[UAcute]meros complejos y visualizaci\[OAcute]n de funciones \
complejas", "Title"],

Cell[TextData[StyleBox[
"F. Javier P\[EAcute]rez Gonz\[AAcute]lez \nDepartamento de An\[AAcute]lisis \
Matem\[AAcute]tico\nUniversidad de Granada",
  FontSize->12]], "Author",
  TextAlignment->Right],

Cell[CellGroupData[{

Cell["Descripci\[OAcute]n de la pr\[AAcute]ctica", "Section"],

Cell[TextData[{
  "Esta pr\[AAcute]ctica consta de dos partes. En la primera se introducen \
algunos comandos b\[AAcute]sicos de ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " para trabajar con n\[UAcute]meros complejos. Comprobar\[AAcute]s que el \
conocimiento de las funciones elementales complejas, en particular los \
logaritmos y las potencias complejas, es importante para entender algunas \
respuestas de ",
  StyleBox["Mathematica.",
    FontSlant->"Italic"],
  " En la segunda parte se introducen comandos espec\[IAcute]ficos para \
representar gr\[AAcute]ficamente funciones complejas. Tu trabajo consiste en \
leer y entender lo que sigue y realizar los ejercicios que te propongo. "
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Aritm\[EAcute]tica. Forma polar. Ra\[IAcute]ces, logaritmos y potencias \
complejas.\
\>", "Section"],

Cell[TextData[{
  "Empezaremos aprendiendo algunos comandos espec\[IAcute]ficos que tiene ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " para trabajar con n\[UAcute]meros complejos. En ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " la letra I may\[UAcute]scula representa la unidad imaginaria. No olvides \
dejar un espacio libre al escribirla. Tambi\[EAcute]n puedes escribir la \
unidad imaginaria tecleando \"\[EscapeKey] ii \[EscapeKey]\"."
}], "Text"],

Cell[BoxData[{
    RowBox[{
      StyleBox[\(z = \(-5\) + I\ 4\),
        "Input"], 
      StyleBox[";",
        "Input"], "\n", 
      StyleBox[\(Re[z]\),
        "Input"]}], 
    StyleBox[\(Im[z]\),
      "Input"], 
    StyleBox[\(Abs[z]\),
      "Input"], \(Arg[z]\), \(Conjugate[z]\), 
    StyleBox[\(Clear[z]\),
      "Input"]}], "Input"],

Cell["\<\
Como ves \"Re[]\" e \"Im[]\" dan la parte real e imaginaria, \"Abs[]\" nos da \
el m\[OAcute]dulo, \"Arg[]\" es el argumento principal y \"Conjugate[]\" es \
el conjugado. \
\>", "Text",
  TextJustification->1],

Cell[TextData[{
  "Te recuerdo que ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "  trabaja  con n\[UAcute]meros complejos por defecto, por eso cuando una \
expresi\[OAcute]n contenga variables no debes olvidar que ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " las tratar\[AAcute] como n\[UAcute]meros complejos.  Por ejemplo, no \
debes pensar que Re[a + i b] debe ser a, puesto que ello s\[OAcute]lo es as\
\[IAcute] cuando a y b son n\[UAcute]meros reales."
}], "Text"],

Cell[BoxData[{
    \(Re[a + I\ b]\), 
    \(Conjugate[a\  + \ I\ b]\), 
    \(Re[\((a + \ I\ b)\) \((c\  + \ I\ d)\)]\)}], "Input"],

Cell[TextData[{
  "Podemos decirle a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " que ciertas variables son reales con la orden",
  StyleBox[" ",
    FontFamily->"Times New Roman"],
  StyleBox["\"",
    FontFamily->"Times New Roman",
    FontSize->10],
  StyleBox["ComplexExpand[expr]\" ",
    FontFamily->"Times New Roman"],
  "que desarrolla ",
  StyleBox["\"",
    FontFamily->"Times New Roman",
    FontSize->10],
  StyleBox["expr", "TI",
    FontFamily->"Times New Roman",
    FontSlant->"Plain"],
  StyleBox["\"", "TI",
    FontFamily->"Times New Roman",
    FontSize->9,
    FontSlant->"Plain"],
  StyleBox[" ",
    FontFamily->"Times New Roman",
    FontSize->14],
  "suponiendo que todas las variables que figuran en la misma son reales."
}], "Text"],

Cell[BoxData[{
    RowBox[{
      StyleBox[
        RowBox[{"C", 
          StyleBox["omplexExpand",
            "Input"]}]], 
      StyleBox["[",
        "Input"], 
      StyleBox[\(Re[a + I\ b]\),
        "Input"], 
      StyleBox["]",
        "Input"]}], "\n", \(ComplexExpand[
      Re[\((a + \ I\ b)\) \((c\  + \ I\ d)\)]]\), "\n", \(\(Conjugate[
        a\  + \ I\ b]\)\(//\)\(ComplexExpand\)\(\ \)\( (*\ 
        esta\ es\ una\ forma\ usual\ de\ escribir\ algunos\ comandos\ de\ \
Mathematica\ *) \)\)}], "Input"],

Cell[TextData[{
  "Para que te convenzas de que Arg[z] es el argumento principal de z, \
observa en la siguiente gr\[AAcute]fica la disontinuidad del argumento en ",
  Cell[BoxData[
      \(TraditionalForm\`t = \[Pi]\)]],
  " y en ",
  Cell[BoxData[
      \(TraditionalForm\`t = \(-\[Pi]\)\)]],
  " puntos en los que salta de \[Pi] a -\[Pi] ."
}], "Text"],

Cell[BoxData[{
    \(\(graf = 
        Plot[Arg[Cos[t] + \ I\ Sin[t]], {t, \(-3\) \[Pi], 3  \[Pi]}, 
          Ticks -> {\[Pi]\ Range[\(-3\), 3], {\(-\[Pi]\), \[Pi]}}, 
          AspectRatio \[Rule] Automatic, 
          DisplayFunction -> Identity];\)\), "\n", 
    \(\(\(Show[
      graf /. {Line[x_]} -> {Line[
              Select[graf[\([1, 1, 1, 
                    1]\)], \((Abs[#[\([1]\)] + 
                          N[2  \[Pi]] - #[\([2]\)]] <  .01)\) &]], 
            Line[Select[
                graf[\([1, 1, 1, 
                    1]\)], \((Abs[#[\([1]\)] - #[\([2]\)]] <  .01)\) &]], 
            Line[Select[
                graf[\([1, 1, 1, 
                    1]\)], \((Abs[#[\([1]\)] - 
                          N[2  \[Pi]] - #[\([2]\)]] <  .01)\) &]]}, 
      DisplayFunction -> $DisplayFunction, 
      ImageSize \[Rule] {402.625, 134}]\)\(;\)\( (*\ 
      como\ la\ gr\[AAcute]fica\ tiene\ discontinuidades\ de\ salto\ he\ \
hecho\ un\ arreglito\ para\ que\ Mathematica\ no\ las\ una\ por\ segmentos\ \
verticales\ *) \)\)\)}], "Input"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " tiene otra funci\[OAcute]n que hace lo mismo que la funci\[OAcute]n \
Arg[], es la funci\[OAcute]n ArcTan[x,y] que proporciona el argumento \
principal del n\[UAcute]mero complejo x + I y. Por tanto, las funciones ",
  Cell[BoxData[
      \(TraditionalForm\`ArcTan[Cos[t], Sin[t]]\)]],
  " y Arg[Cos[t] + I Sin[t]]  son la misma. Podemos comprobarlo \
gr\[AAcute]ficamente."
}], "Text"],

Cell[BoxData[{
    \(Clear[graf]\), "\[IndentingNewLine]", 
    \(\(graf = 
        Plot[ArcTan[Cos[y], Sin[y]], {y, \(-3\) \[Pi], 3  \[Pi]}, 
          Ticks -> {\[Pi]*Range[\(-3\), 3], {\(-\[Pi]\), \[Pi]}}, 
          AspectRatio \[Rule] Automatic, 
          DisplayFunction -> Identity];\)\), "\n", 
    \(\(\(Show[
      graf /. {Line[x_]} -> {Line[
              Select[graf[\([1, 1, 1, 
                    1]\)], \((Abs[#[\([1]\)] + 
                          N[2  \[Pi]] - #[\([2]\)]] <  .01)\) &]], 
            Line[Select[
                graf[\([1, 1, 1, 
                    1]\)], \((Abs[#[\([1]\)] - #[\([2]\)]] <  .01)\) &]], 
            Line[Select[
                graf[\([1, 1, 1, 
                    1]\)], \((Abs[#[\([1]\)] - 
                          N[2  \[Pi]] - #[\([2]\)]] <  .01)\) &]]}, 
      DisplayFunction -> $DisplayFunction, 
      ImageSize \[Rule] {402.625, 134}]\)\(;\)\( (*\ 
      es\ la\ misma\ gr\[AAcute]fica\ anterior\ *) \)\)\)}], "Input"],

Cell[TextData[{
  "Observa que  ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(ArcTan[Cos[t], Sin[t]]\)\(=\)\(t\)\(\ \)\)\)]],
  "solamente cuando ",
  Cell[BoxData[
      \(TraditionalForm\`\(-\[Pi]\) < t \[LessEqual] \[Pi]\)]],
  "."
}], "Text"],

Cell["\<\
No hay ninguna novedad en lo referente a la multiplicaci\[OAcute]n y a la \
divisi\[OAcute]n de n\[UAcute]meros complejos: se hacen de la forma usual. \
Para obtener el resultado en forma cartesiana hay que usar a  veces \
\"ComplexEx\[AGrave]nd[ ]\".\
\>", "Text"],

Cell[BoxData[{
    \(\(3 + 4\ I\)\/\(5 - 2\ I\)\), "\[IndentingNewLine]", 
    \(\@\(\(2 - 3\ I\)\/\(3 + 5  I\)\)\), "\[IndentingNewLine]", 
    \(\@\(\(2 - 3\ I\)\/\(3 + 5  I\)\) // ComplexExpand\)}], "Input"],

Cell[TextData[{
  "Tambi\[EAcute]n se hacen de la forma usual las potencias. Mererece la pena \
detenerse en las potencias de exponente racional y complejo para entender c\
\[OAcute]mo trabaja ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " con ellas. Vamos a considerar las ra\[IAcute]ces de un n\[UAcute]mero \
complejo. Ya sabes que todo n\[UAcute]mero complejo distinto de cero tiene n \
ra\[IAcute]ces n-\[EAcute]simas distintas. \[DownQuestion]Cu\[AAcute]l de \
ellas es la que se representa en ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " por z^(1/n) o, lo que es igual, por ",
  Cell[BoxData[
      \(TraditionalForm\`\@z\%n\)]],
  "? Para saberlo podemos usar ComplexExpand."
}], "Text"],

Cell[BoxData[
    \(ComplexExpand[\((x\  + \ I\ y)\)^{1/3}]\)], "Input"],

Cell[TextData[{
  "Es decir, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " proporciona siempre el ",
  StyleBox["valor principal",
    FontSlant->"Italic"],
  " de la ra\[IAcute]z. Ahora puedes comprender por qu\[EAcute] si le pides a \
",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " que calcule ",
  Cell[BoxData[
      \(TraditionalForm\`\@\(x\^3\)\%3\)]],
  "la respuesta no puede ser ",
  StyleBox["x",
    FontSlant->"Italic"],
  ". F\[IAcute]jate que si ",
  StyleBox["x",
    FontSlant->"Italic"],
  " es real entonces s\[IAcute] es cierto es que ",
  StyleBox["x ",
    FontSlant->"Italic"],
  "es la \[UAcute]nica ra\[IAcute]z c\[UAcute]bica ",
  StyleBox["real",
    FontSlant->"Italic"],
  " de ",
  Cell[BoxData[
      \(TraditionalForm\`x\^3\)]],
  ", pero ",
  StyleBox["Mathematica,",
    FontSlant->"Italic"],
  " por defecto, trata ",
  StyleBox["x",
    FontSlant->"Italic"],
  " como un n\[UAcute]mero complejo y hay ",
  StyleBox["tres",
    FontSlant->"Italic"],
  " complejos distintos que tienen igual cubo. Por eso la igualdad ",
  Cell[BoxData[
      \(TraditionalForm\`\@\(z\^3\)\%3 = z\)]],
  " no es cierta en general. Ya debes saber que dicha igualdad se verificar\
\[AAcute] solamente cuando -\[Pi]/3<Arg[z]\[LessEqual]\[Pi]/3. \
Tambi\[EAcute]n puedes entender por qu\[EAcute] si pides a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " que calcule ",
  Cell[BoxData[
      \(TraditionalForm\`\(\@z\) \@w\)]],
  " la respuesta no puede ser ",
  Cell[BoxData[
      \(TraditionalForm\`\@\(z\ w\)\)]],
  "."
}], "Text"],

Cell[BoxData[{
    \(\@\(z\^3\)\%\(3\ \)\), 
    \(\(\@z\) \@w\)}], "Input"],

Cell[TextData[{
  StyleBox["Nota importante",
    FontWeight->"Bold"],
  ". Esta pr\[AAcute]ctica la prepar\[EAcute] con la versi\[OAcute]n 5.0 de \
",
  StyleBox["Mathematica. ",
    FontSlant->"Italic"],
  "Al probarla con la versi\[OAcute]n 3.0 he comprobado que el comando \
\"Simplify\" que en la versi\[OAcute]n 5.0 y en la 4.1 admite ser usado de la \
forma \"Simplify[expr,condiciones]\" no puede ser usado con \"condiciones\" \
en la versi\[OAcute]n 3.0. Por ello, en lo que sigue, hay algunas celdas que \
ya est\[AAcute]n ejecutadas usando la versi\[OAcute]n 5.0 y no debes volver a \
ejecutarlas en clase de pr\[AAcute]cticas porque ",
  StyleBox["Mathematica ",
    FontSlant->"Italic"],
  "3.0 que es la versi\[OAcute]n de ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " que est\[AAcute] instalada en los ordenadores de la Escuela te dar\
\[AAcute] un mensaje de error y perder\[AAcute]s la informaci\[OAcute]n."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\( (*\ 
      no\ eval\[UAcute]es\ esta\ celda\ *) \)\(\n\)\(Simplify[\@\(z\^3\)\%3\ \
, \(-\[Pi]\)/3 < Arg[z] \[LessEqual] \ \[Pi]/3]\)\(\ \)\)\)], "Input"],

Cell[BoxData[
    \(z\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\( (*\ 
      no\ eval\[UAcute]es\ esta\ celda\ *) \)\(\n\)\(Simplify[\@\(z\^3\)\%3\ \
, \(-\[Pi]\)/3 \[LessEqual] \ 
        Arg[z] \[LessEqual] \ \[Pi]/
          3]\)\(\ \)\( (*\ \(Una\ peque\[NTilde]a\ diferencia\ con\ la\ \
anterior\ pero ... \)\ \[DownExclamation]las\ matem\[AAcute]ticas\ son\ \
\(exactas!\)\ *) \)\)\)], "Input"],

Cell[BoxData[
    \(\((z\^3)\)\^\(1/3\)\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \(\(\(ComplexExpand[\@\(I\^3\)\%3]\ \ \ \) (*\ 
      en\ general\ no\ es\ cierto\ que\ \@\(z\^3\)\%3\ sea\ igual\ a\ z\ *) 
      \)\)], "Input"],

Cell[BoxData[
    \(\(\(ComplexExpand[\@\(-1\)\%3]\)\(\ \)\( (*\ 
      en\ este\ c\[AAcute]lculo\  - 
        1\ es\ tratado\ como\ n\[UAcute]mero\ complejo\ y\ Mathematica\ \
proporciona\ el\ valor\ principal\ de\ la\ ra\[IAcute]z\ *) \)\)\)], "Input"],

Cell[BoxData[{
    \(\(\@\(-I\)\) \@\(-I\)\ \ \ \ \ \ \ \  (*\ 
      en\ general\ no\ es\ cierto\ que\ \(\@z\) \@w\ sea\ igual\ a\ 
        \@\(z*w\)\ *) \), 
    \(\@\(\((\(-I\))\)*\((\(-I\))\)\)\)}], "Input"],

Cell[TextData[{
  "Ya ves que saber un poquito de n\[UAcute]meros complejos ayuda a entender \
lo que hace ",
  StyleBox["Mathematica.",
    FontSlant->"Italic"],
  " Para obtener todas las ra\[IAcute]ces de orden n de un n\[UAcute]mero \
complejo puedes usar el comando \"Solve\". "
}], "Text"],

Cell[TextData[{
  "Veamos c\[OAcute]mo trabaja ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " con los logaritmos complejos."
}], "Text"],

Cell[BoxData[
    \(ComplexExpand[Log[x\  + \ I\ y]]\)], "Input"],

Cell[TextData[{
  "Es decir, la funci\[OAcute]n Log[z] nos da el ",
  StyleBox["valor principal ",
    FontSlant->"Italic"],
  "del logaritmo de z. Ahora puedes entender la siguiente respuesta de ",
  StyleBox["Mathematica.",
    FontSlant->"Italic"]
}], "Text"],

Cell[BoxData[{
    \(Exp[Log[z]]\), 
    \(Log[Exp[z]]\ \  (*\ 
      en\ general\ no\ es\ verdad\ que\ Log[Exp[z]]\ sea\ igual\ a\ z\ *) 
      \), 
    \(Log[Exp[7\ I]]\  (*\ aqu\[IAcute]\ tienes\ un\ ejemplo\ *) \)}], "Input"],

Cell["Veamos lo que vale Log[Exp[z]].", "Text"],

Cell[BoxData[
    \(ComplexExpand[Log[Exp[x\  + \ I\ y]]]\)], "Input"],

Cell[TextData[{
  "Ya has visto antes que no siempre es cierto que ArcTan[Cos[y],Sin[y]] sea \
igual a y. De hecho la igualdad ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(ArcTan[Cos[y], 
          Sin[y]]\)\(=\)\(y\)\(\ \ \)\)\)]],
  "es cierta solamente cuando ",
  Cell[BoxData[
      \(TraditionalForm\`\(-\[Pi]\) < y \[LessEqual] \[Pi]\)]],
  ". Por tanto, la igualdad ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(\ \)\(Log[Exp[x\  + \ I\ y]] = 
        x\  + \ I\ y\)\)\)]],
  " es cierta solamente cuando ",
  Cell[BoxData[
      \(TraditionalForm\`\(-\[Pi]\) < y \[LessEqual] \[Pi]\)]],
  "."
}], "Text"],

Cell[BoxData[{
    \(ComplexExpand[Log[\(-1\) + I\ \@3] + Log[\(-\@3\) + I]]\  (*\ 
      en\ general\ no\ es\ verdad\ que\ Log[z]\  + \ 
        Log[w]\ sea\ igua\ a\ Log[z*w]\ pues\ pueden\ diferenciarse\ en\ un\ 
          m\[UAcute]ltiplo\ entero\ de\ 2  \[Pi]I\ *) \), 
    \(ComplexExpand[Log[\((\(-1\) + I\ \@3)\) \((\(-\@3\) + I)\)]]\)}], 
  "Input"],

Cell["\<\
Consideremos a continuaci\[OAcute]n las potencias de base y exponente \
complejos.\
\>", "Text"],

Cell[BoxData[
    \(ComplexExpand[\((a\  + \ I\ b)\)^\((c\  + \ I\ d)\)]\)], "Input"],

Cell[TextData[{
  "Parece demasiado complicado. Recordemos la definici\[OAcute]n del valor \
principal de la potencia ",
  Cell[BoxData[
      \(TraditionalForm\`\((a\  + \ I\ b)\)\^\((c\  + \ I\ d)\) = \
\(\(Exp[\((c\  + \ I\ d)\) Log[a\  + \ I\ b]]\)\(.\)\)\)]]
}], "Text"],

Cell[BoxData[
    \(ComplexExpand[Exp[\((c\  + \ I\ d)\) Log[a\  + \ I\ b]]]\)], "Input"],

Cell[TextData[{
  "Est\[AAcute] claro que ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " calcula el",
  StyleBox[" valor principal",
    FontSlant->"Italic"],
  " de la potencia."
}], "Text"],

Cell[BoxData[{
    \(ComplexExpand[\((\((\(-I\))\)*\((\(-I\))\))\)^I]\ \  (*\ 
      en\ general\ no\ es\ cierto\ que\ \((u*v)\)\^z\ sea\ igual\ a\ u\^z*
        v\^z\ *) \), 
    \(ComplexExpand[\((\(-I\))\)^I\ *\((\(-\ I\))\)^I]\), 
    \(Clear["\<Global`*\>"]\)}], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Visualizaci\[OAcute]n de funciones complejas", "Section"],

Cell[TextData[{
  "Cualquier funci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm
      \`f\  : \ \[DoubleStruckCapitalC] \[Rule] \[DoubleStruckCapitalC]\)]],
  "  podemos verla como una funci\[OAcute]n de ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^2\)]],
  " en  ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^2\)]],
  " y  por tanto para su representaci\[OAcute]n necesitariamos \
gr\[AAcute]ficos en cuatro dimensiones. Lo que podemos hacer para visualizar \
su comportamiento es representar c\[OAcute]mo se transforma una familia de \
curvas como, por ejemplo, rectas paralelas a los ejes o circunferencias \
centradas en el origen. "
}], "Text",
  TextJustification->1],

Cell[TextData[{
  "Veamos un ejemplo de esto. Vamos a considerar la familia ",
  StyleBox["circunferencias",
    FontSlant->"Italic"],
  " formada por nueve circunferencias centradas en el origen y de radios r \
desde 0.1 hasta 1 (cada una en el color Hue[r]). Haremos actuar sobre dichas \
circunferencias la funci\[OAcute]n ",
  Cell[BoxData[
      FormBox[
        FormBox[
          RowBox[{\(f(z)\), "=", 
            FormBox[\(\(1 - z\)\/\(1 + z\)\),
              "TraditionalForm"]}],
          "TraditionalForm"], TraditionalForm]]],
  " y obtendremos la familia ",
  StyleBox["imagencircunferencias",
    FontSlant->"Italic"],
  "."
}], "Text"],

Cell[BoxData[{
    \(\(Clear[f, z, circunferencias, imagencircunferencias];\)\), "\n", 
    \(\(f[z_] := \((1 - z)\)/\((1 + z)\);\)\), "\n", 
    \(\(circunferencias = 
        ParametricPlot[
          Evaluate[
            Table[r {Cos[t], \ Sin[t]}, \ {r, \  .1, \ 1, \  .1}]], \ {t, 0, 
            2\ Pi}, \ \n\t\tPlotStyle -> 
            Table[Hue[r], \ {r, \  .1, 1,  .1}], \n\t\tAspectRatio -> 
            1, \n\t\tAxesLabel -> {"\<x\>", "\<y\>"}, \n\t\tFrame -> 
            True, \t\n\t\tDisplayFunction -> Identity];\)\n\t\t\), "\n", 
    \(\(imagencircunferencias = 
        ParametricPlot[\n\t\tEvaluate[
            Table[{Re[f[r\ Cos[t] + I\ r\ \ Sin[t]]], \ 
                Im[f[r\ Cos[t] + I\ r\ \ Sin[t]]]}, \ {r, \  .1, \ 
                1, \  .1}]], \ {t, 0, 2\ Pi}, \ \n\t\tPlotStyle -> 
            Table[Hue[r], \ {r, \  .1, 1,  .1}], \n\t\tPlotRange -> {{0, 
                6}, {\(-3\), 3}}, \n\t\tAspectRatio -> 
            1, \n\t\tAxesLabel -> {"\<u\>", "\<v\>"}, \n\t\tFrame -> 
            True, \n\t\tDisplayFunction -> Identity];\)\n\t\t\), "\n", 
    \(Print["\<Familia de circunferencias C(0,r); r=0.1-1\>"]; 
    Show[{circunferencias}, \ 
      DisplayFunction -> $DisplayFunction];\n\), "\n", 
    \(\(Print["\<Imagen por f(z)=\>", 
        f[z], \ "\<de la familia de circunferencias C(0,r); r=0.1-1\>"];\)\), \
"\n", 
    \(\(Show[{imagencircunferencias}, \ 
        DisplayFunction -> $DisplayFunction];\)\), "\[IndentingNewLine]", 
    \(\(Clear[f, z, circunferencias, imagencircunferencias];\)\)}], "Input"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " posee un comando que nos permite ver la imagen de una familia de rectas \
paralelas a los ejes mediante una funci\[OAcute]n compleja. Para ello es \
necesario cargar el paquete ComplexMap. "
}], "Text"],

Cell[BoxData[
    \(<< Graphics`ComplexMap`\)], "Input"],

Cell["\<\
Tambi\[EAcute]n es conveniente cargar el siguiente paquete para trabajar con \
comodidad con colores.\
\>", "Text"],

Cell[BoxData[
    \(\(Needs["\<Graphics`Colors`\>"]; 
    \ \  (*para\ usar\ colores\ con\ comodidad*) \nOff[General::spell1]; \ \ 
    \n (*para\ que\ Mathematica\ no\ nos\ moleste\ con\ avisos\ de\ error\ en
        \ los\ nombres\ de\ los\ comandos*) \)\)], "Input"],

Cell[BoxData[
    \(\(?\ CartesianMap\)\)], "Input"],

Cell["\<\
Utilizando este comando puedes ver c\[OAcute]mo una determinada \
funci\[OAcute]n act\[UAcute]a sobre una regi\[OAcute]n del plano y adem\
\[AAcute]s c\[OAcute]mo transforma los segmentos verticales y los \
horizontales. Aqu\[IAcute] tienes un bonito ejemplo con la aplicaci\[OAcute]n \
f(z)=1/z.\
\>", "Text"],

Cell[BoxData[
    \(f[z_] = 1/z; \n
    CartesianMap[Identity, \ {0.5, 10, 0.5}, {\(-5\), 5, 0.5}, 
      \[IndentingNewLine]Ticks 
        \[Rule] {Range[0, 10, 2], Range[\(-5\), 5, 1]}, 
      AxesLabel \[Rule] {"\<x\>", "\<y\>"}, PlotStyle \[Rule] {Blue, Red}]; \n
    Print["\<El semiplano Re[z] > 1/2\>"]; \n
    CartesianMap[f, \ {0.5, 10, 0.5}, {\(-5\), 5, 0.5}, 
      \[IndentingNewLine]PlotRange 
        \[Rule] {{\(-0.1\), 2.1}, {\(-1.1\), 1.1}}, 
      \[IndentingNewLine]AspectRatio \[Rule] 1, 
      Ticks \[Rule] {Range[0, 2, 1], Range[\(-2\), 2, 1]}, 
      AxesLabel \[Rule] {"\<u\>", "\<v\>"}, PlotStyle \[Rule] {Blue, Red}]; \n
    Print["\<Su imagen por f(z)=1/z es el disco |w - 1| < 1\>"]; \n
    Clear[f]\)], "Input",
  AspectRatioFixed->True],

Cell["Teniendo en cuenta que:", "Text"],

Cell[BoxData[
    \(ComplexExpand[Exp[x\  + \ I\ y]]\)], "Input"],

Cell[TextData[{
  "Es evidente que la imagen por la funci\[OAcute]n exponencial de una recta \
vertical (x constante) es una circunferencia centrada en el origen de radio ",
  
  Cell[BoxData[
      \(TraditionalForm\`e\^x\)]],
  ", y la imagen de una recta horizontal (y constante) es una semirecta con \
extremo en el origen y vector de direcci\[OAcute]n (Cos[y],Sin[y])."
}], "Text"],

Cell[TextData[
"Aqu\[IAcute] puedes ver c\[OAcute]mo la funci\[OAcute]n exponencial \
transforma rect\[AAcute]ngulos en sectores de corona circular. Utiliza los \
controles para ver despacio la animaci\[OAcute]n. Observa c\[OAcute]mo la \
imagen de la funci\[OAcute]n exponencial va cambiando. Mantenemos fijo el \
intervalo de abscisas (la anchura del rect\[AAcute]ngulo) [-1,1] (del cual \
depende el m\[OAcute]dulo de la imagen) y vamos aumentando el intervalo de \
ordenadas (la altura del rect\[AAcute]ngulo) desde [-\[Pi]/10, \[Pi]/10] \
hasta [-\[Pi], \[Pi]] (del que dependen los argumentos de la imagen)."], 
  "Text"],

Cell[BoxData[{
    \(Do[Show[
        GraphicsArray[{
            CartesianMap[Identity, 
              \ {\(-1\), 1, 0.1}, {\(-k\)\ \[Pi], k\ \[Pi], 0.1}, 
              AxesLabel \[Rule] {"\<x\>", "\<y\>"}, 
              PlotStyle \[Rule] {Red, Blue}, Ticks \[Rule] None, 
              PlotRange \[Rule] {{\(-3\), 3}, {\(-3\), 3}}, 
              ImageSize \[Rule] {356, 170}, 
              DisplayFunction \[Rule] Identity], 
            CartesianMap[Exp, 
              \ {\(-1\), 1, 0.1}, {\(-k\)\ \[Pi], k\ \[Pi], 0.1}, 
              \[IndentingNewLine]AxesLabel \[Rule] {"\<u\>", "\<v\>"}, 
              PlotStyle \[Rule] {Red, Blue}, Ticks \[Rule] None, 
              PlotRange \[Rule] {{\(-3\), 3}, {\(-3\), 3}}, 
              ImageSize \[Rule] {356, 170}, 
              DisplayFunction \[Rule] Identity]}]], {k,  .1, 1,  .2}]; \n
    SelectionMove[EvaluationNotebook[], All, GeneratedCell]; \n
    FrontEndTokenExecute["\<CellGroup\>"]\), 
    \(FrontEndTokenExecute["\<OpenCloseGroup\>"]\)}], "Input"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " posee un comando que nos permite ver la imagen por una funci\[OAcute]n \
compleja de una familia de rectas que pasan por el origen y de una familia de \
circunferencias centradas en el origen."
}], "Text"],

Cell[BoxData[
    \(\(?PolarMap\)\)], "Input"],

Cell[BoxData[
    \(\(PolarMap[Identity, \ {0, 1}, {\(-Pi\)\  +  .00001, \ Pi}, 
      PlotStyle -> {Red, Blue}]; \)\)], "Input"],

Cell[TextData[{
  "Aqu\[IAcute] tienes la imagen por la funci\[OAcute]n logaritmo de la \
corona circular {z \[Epsilon] ",
  StyleBox["\[DoubleStruckC] ",
    FontSize->16],
  Cell[BoxData[
      \(TraditionalForm\`\( : \(e\^\(-3\) < \) | z | \( < e\)\^3\)\)]],
  "} . Observa c\[OAcute]mo los radios se convierten en segmentos \
horizontales y las circunferencias en segmentos verticales."
}], "Text"],

Cell[BoxData[
    \(\(Show[
      GraphicsArray[{{
            PolarMap[Identity, {E^\(-3\), E^3}, {\(-Pi\) +  .00001, Pi}, 
              PlotStyle \[Rule] {Red, Blue}, 
              DisplayFunction \[Rule] Identity], 
            \[IndentingNewLine]PolarMap[
              Log, {E^\(-3\), E^3, E^\(-2\)}, {\(-Pi\) +  .00001, Pi}, 
              PlotStyle \[Rule] {Red, Blue}, 
              PlotRange \[Rule] {{\(-3.1\), 3.1}, {\(-3.6\), 3.6}}, 
              DisplayFunction \[Rule] Identity]}}], 
      ImageSize \[Rule] {430, 204.625}]; \)\)], "Input"],

Cell[CellGroupData[{

Cell[TextData[{
  " ",
  StyleBox["Ejercicio 1",
    FontWeight->"Bold"]
}], "Exercise"],

Cell[TextData[{
  "Te propongo que realices un programa para dibujar pol\[IAcute]gonos \
regulares de cualquier n\[UAcute]mero de lados inscritos en la circunferencia \
unidad y que tambi\[EAcute]n represente las ra\[IAcute]ces k-\[EAcute]simas \
de la unidad por vectores (para dibujar vectores necesitar\[AAcute]s \
\"<<Graphics`Arrow`\"). Los pasos y las funciones de Mathematica que quiero \
que uses te los indico a continuaci\[OAcute]n (cada paso debe ser una corta l\
\[IAcute]nea de c\[OAcute]digo). Naturalmente, hay formas mucho m\[AAcute]s \
inmediatas de hacer esto pero se trata de que uses ciertos recursos de ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ".\n1. Obt\[EAcute]n una lista \"raices[k]\" con las ra\[IAcute]ces k-\
\[EAcute]simas de la unidad. Combina para ello el operador de sustituci\
\[OAcute]n \"/.\" y \"NSolve\". As\[IAcute] obtienes las ra\[IAcute]ces k-\
\[EAcute]simas de la unidad pero si ahora las unes por una poligonal no es \
seguro que consigas un pol\[IAcute]gono porque las ra\[IAcute]ces obtenidas \
no est\[AAcute]n ordenadas de la manera adecuada. Nos interesa ordenarlas de \
forma que al unirlas por segmentos obtengamos un pol\[IAcute]gono regular de \
k lados. Una forma de hacerlo es como sigue.\n2. Obt\[EAcute]n una lista con \
los argumentos principales de las ra\[IAcute]ces. Usa Transpose[ ] para \
combinar las dos listas y Sort[ ] para ordenar esta \[UAcute]ltima por \
argumentos crecientes. Con una regla de sustituci\[OAcute]n adecuada recupera \
la lista raices[k] ordenadas por argumentos crecientes. \n3. Aplica de forma \
apropiada \"Arrow\" a los puntos de la lista anterior para representar las ra\
\[IAcute]ces por vectores \"vectores[k]\". Obtendr\[AAcute]s una lista con \
los vectores correspondientes.\n4. Salvo un detalle que t\[UAcute] mismo \
decubrir\[AAcute]s, ya s\[OAcute]lo te queda usar \"Show\",\"Line\", \"Circle\
\" con las opciones adecuadas para obtener la funci\[OAcute]n \
\"poligonoregular[k]\" que realiza las tareas deseadas. Dale un valor a k y \
comprueba que todo funciona bien."
}], "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  " ",
  StyleBox["Ejercicio 2",
    FontWeight->"Bold"]
}], "Exercise"],

Cell["\<\
Utiliza CartesianMap para obtener las im\[AAcute]genes del cuadrado unidad \
por las funciones seno y tangente. \
\>", "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  " ",
  StyleBox["Ejercicio 3",
    FontWeight->"Bold"]
}], "Exercise"],

Cell["\<\
Utiliza ComplexExpand y ParametricPlot para obtener las im\[AAcute]genes por \
la funci\[OAcute]n seno y tangente de un segmento vertical y de un segmento \
horizontal.\
\>", "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  " ",
  StyleBox["Ejercicio 4",
    FontWeight->"Bold"]
}], "Exercise"],

Cell[TextData[
"Haz una animaci\[OAcute]n para ver la imagen por la funci\[OAcute]n ra\
\[IAcute]z cuadrada de un sector del disco unidad cuya amplitud va aumentando \
a saltos de \[Pi]/5. "], "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  " ",
  StyleBox["Ejercicio 5",
    FontWeight->"Bold"]
}], "Exercise"],

Cell[TextData[{
  "Representa la imagen del disco ",
  Cell[BoxData[
      \(TraditionalForm\`D(\((1 + \[ImaginaryI])\)/2, 1/2)\)]],
  " y su imagen por la funci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`f(z) = z\^4\)]],
  ". Elige de forma apropiada el n\[UAcute]mero de radios y de \
circunferencias que se representar\[AAcute]n."
}], "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  " ",
  StyleBox["Ejercicio 6",
    FontWeight->"Bold"]
}], "Exercise"],

Cell[TextData[{
  "Justifica gr\[AAcute]ficamente que la aplicaci\[OAcute]n  ",
  Cell[BoxData[
      \(TraditionalForm\`w = \(u + \[ImaginaryI]\ v = 
          Log(\(1\  + \ z\)\/\(1\  - \ z\))\)\)]],
  "  lleva el disco unidad  ",
  Cell[BoxData[Cell["|z|< 1"]]],
  "  sobre la banda horizontal ",
  Cell[BoxData[
      FormBox[
        RowBox[{" ", 
          RowBox[{"|", "v", "|", 
            RowBox[{"<", 
              FormBox[\(\[Pi]/2\),
                "TraditionalForm"]}]}]}], TraditionalForm]]],
  "."
}], "ExerciseText",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 670}},
WindowSize->{1016, 635},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
PageHeaders->{{Cell[ 
        TextData[ 
        "F. Javier P\[EAcute]rez Gonz\[AAcute]lez\nDpto. An\[AAcute]lisis \
Matem\[AAcute]tico - Universidad de Granada"], "Header"], Cell[ 
        TextData[ {
          CounterBox[ "Page"]}], "PageNumber"], Cell[ 
        TextData[ 
        "N\[UAcute]meros complejos. Visualizaci\[OAcute]n de funciones \
complejas"], "Header"]}, {Cell[ 
        TextData[ 
        "F. Javier P\[EAcute]rez Gonz\[AAcute]lez\nDpto. An\[AAcute]lisis \
Matem\[AAcute]tico - Universidad de Granada"], "Header"], Cell[ 
        TextData[ {
          CounterBox[ "Page"]}], "PageNumber"], Cell[ 
        TextData[ 
        "N\[UAcute]meros complejos. Visualizaci\[OAcute]n de funciones \
complejas"], "Header"]}},
PrintingOptions->{"FirstPageHeader"->False,
"FacingPages"->True},
Magnification->1.5,
StyleDefinitions -> "Classroom.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1754, 51, 91, 1, 174, "Title"],
Cell[1848, 54, 199, 4, 102, "Author"],

Cell[CellGroupData[{
Cell[2072, 62, 61, 0, 93, "Section"],
Cell[2136, 64, 719, 14, 145, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2892, 83, 111, 3, 93, "Section"],
Cell[3006, 88, 480, 10, 93, "Text"],
Cell[3489, 100, 343, 13, 228, "Input"],
Cell[3835, 115, 220, 5, 67, "Text"],
Cell[4058, 122, 496, 11, 93, "Text"],
Cell[4557, 135, 131, 3, 124, "Input"],
Cell[4691, 140, 773, 27, 70, "Text"],
Cell[5467, 169, 520, 15, 150, "Input"],
Cell[5990, 186, 355, 9, 67, "Text"],
Cell[6348, 197, 1063, 22, 358, "Input"],
Cell[7414, 221, 458, 10, 93, "Text"],
Cell[7875, 233, 987, 21, 358, "Input"],
Cell[8865, 256, 248, 8, 41, "Text"],
Cell[9116, 266, 275, 5, 67, "Text"],
Cell[9394, 273, 210, 3, 231, "Input"],
Cell[9607, 278, 721, 16, 120, "Text"],
Cell[10331, 296, 72, 1, 72, "Input"],
Cell[10406, 299, 1583, 53, 153, "Text"],
Cell[11992, 354, 76, 2, 117, "Input"],
Cell[12071, 358, 949, 20, 145, "Text"],

Cell[CellGroupData[{
Cell[13045, 382, 179, 3, 134, "Input"],
Cell[13227, 387, 35, 1, 93, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[13299, 393, 359, 7, 188, "Input"],
Cell[13661, 402, 53, 1, 96, "Output"]
}, Open  ]],
Cell[13729, 406, 164, 3, 85, "Input"],
Cell[13896, 411, 254, 4, 137, "Input"],
Cell[14153, 417, 211, 4, 109, "Input"],
Cell[14367, 423, 295, 7, 67, "Text"],
Cell[14665, 432, 148, 5, 41, "Text"],
Cell[14816, 439, 65, 1, 72, "Input"],
Cell[14884, 442, 262, 7, 67, "Text"],
Cell[15149, 451, 229, 5, 124, "Input"],
Cell[15381, 458, 47, 0, 41, "Text"],
Cell[15431, 460, 70, 1, 72, "Input"],
Cell[15504, 463, 618, 17, 93, "Text"],
Cell[16125, 482, 358, 6, 196, "Input"],
Cell[16486, 490, 106, 3, 41, "Text"],
Cell[16595, 495, 85, 1, 72, "Input"],
Cell[16683, 498, 275, 6, 62, "Text"],
Cell[16961, 506, 89, 1, 72, "Input"],
Cell[17053, 509, 203, 8, 41, "Text"],
Cell[17259, 519, 276, 5, 150, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[17572, 529, 63, 0, 93, "Section"],
Cell[17638, 531, 728, 17, 93, "Text"],
Cell[18369, 550, 654, 18, 98, "Text"],
Cell[19026, 570, 1554, 28, 800, "Input"],
Cell[20583, 600, 274, 6, 67, "Text"],
Cell[20860, 608, 56, 1, 72, "Input"],
Cell[20919, 611, 125, 3, 41, "Text"],
Cell[21047, 616, 269, 4, 150, "Input"],
Cell[21319, 622, 52, 1, 72, "Input"],
Cell[21374, 625, 320, 6, 67, "Text"],
Cell[21697, 633, 767, 15, 332, "Input"],
Cell[22467, 650, 39, 0, 41, "Text"],
Cell[22509, 652, 65, 1, 72, "Input"],
Cell[22577, 655, 386, 8, 93, "Text"],
Cell[22966, 665, 627, 9, 119, "Text"],
Cell[23596, 676, 1020, 19, 410, "Input"],
Cell[24619, 697, 277, 6, 67, "Text"],
Cell[24899, 705, 46, 1, 72, "Input"],
Cell[24948, 708, 129, 2, 72, "Input"],
Cell[25080, 712, 402, 9, 74, "Text"],
Cell[25485, 723, 558, 11, 228, "Input"],

Cell[CellGroupData[{
Cell[26068, 738, 88, 4, 68, "Exercise"],
Cell[26159, 744, 2106, 30, 515, "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{
Cell[28302, 779, 88, 4, 68, "Exercise"],
Cell[28393, 785, 144, 3, 41, "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{
Cell[28574, 793, 88, 4, 68, "Exercise"],
Cell[28665, 799, 200, 4, 67, "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{
Cell[28902, 808, 88, 4, 68, "Exercise"],
Cell[28993, 814, 208, 3, 67, "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{
Cell[29238, 822, 88, 4, 68, "Exercise"],
Cell[29329, 828, 364, 9, 67, "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{
Cell[29730, 842, 88, 4, 68, "Exercise"],
Cell[29821, 848, 583, 18, 73, "ExerciseText",
  Evaluatable->False]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

